; Menu.asm - demonstrates use of menus
;

%define _WINMESSAGES_
%include "Gaz\Win32\Include\Windows.inc"

%include "Menu.ash"

[BITS 32]
[section .text]

procglobal WinMain, hInstance, hPrevInstance, lpszCmdLine, nCmdShow
	ddlocal		_hwnd
	struclocal	_wndclass, WNDCLASSEX, _msg, MSG
	endlocals
	WinMainPrologue
	mov	esi, ._wndclass
	mov	edi, ._msg
	mov	[esi + WNDCLASSEX.cbSize], dword WNDCLASSEX_size
	mov	[esi + WNDCLASSEX.style], dword CS_HREDRAW | CS_VREDRAW
	mov	[esi + WNDCLASSEX.lpfnWndProc], dword _WndProc
	mov	[esi + WNDCLASSEX.cbClsExtra], dword 0
	mov	[esi + WNDCLASSEX.cbWndExtra], dword 0
	mov	eax, .hInstance
	mov	[esi + WNDCLASSEX.hInstance], eax
	sc LoadIcon, NULL, IDI_APPLICATION
	mov	[esi + WNDCLASSEX.hIcon], eax
	sc LoadCursor, NULL, IDC_ARROW
	mov	[esi + WNDCLASSEX.hCursor], eax
	sc GetStockObject, WHITE_BRUSH
	mov	[esi + WNDCLASSEX.hbrBackground], eax
	;
	; We can specify the menu to use for the window class rather than
	; passing a null value (as we've done previously). If we do this,
	; we pass the address of a null-terminated string that holds the
	; name of the menu (as defined in Menu.rc). Every window created
	; from this window class will have the menu we specify here
	; automatically assigned to it. You may be wondering how we would
	; use a different menu for a window created from this window
	; class though, see below for this
	;
	TEXTlocal szMenuName, 'MENU1',0
	mov	[esi + WNDCLASSEX.lpszMenuName], dword .szMenuName
	TEXTlocal szClassName, 'MyClass',0
	mov	[esi + WNDCLASSEX.lpszClassName], dword .szClassName
	sc RegisterClassEx, esi
	cmp	eax, TRUE
	je	near _WinMain_Fail
	;
	; The ninth parameter to CreateWindowEx can be a handle to a menu.
	; If you pass NULL it defaults to using the window class' menu,
	; but you could load a menu instead by:
	;
	;   sc LoadMenu, .hInstance, ._szMenuName
	;
	; Where .hInstance is the handle of the module containing the
	; resource and ._szMenuName is the address of a null-terminated
	; string holding the menu's name (as defined in the resource file)
	;
	; The return value from the above call should be stored and passed
	; to CreateWindowEx.
	;
	; Sometimes you may want to assign a menu on demand, and this can
	; be achieved by:
	;
	;   sc SetMenu, ._hwnd, eax
	;
	; Assuming eax holds the return value of LoadMenu that is.
	;
	; Menus currently on a window are automatically destroyed by windows
	; when the window is destroyed (eg the program terminates) but
	; those that aren't should be destroyed explicitly by calls to
	; DestroyMenu. It is _very important_ that you get into the habit
	; of destroying any resources loaded in this way as:
	;
	;   1. There are limited resources on any computer
	;   2. Users shouldn't have to reboot because of _your_ errors
	;   3. It becomes _extremely_ important when you write critical
	;      apps, eg webserver DLLs which you can't just reboot
	;   4. It's good practice and there's no reason to be lazy
	;
	TEXTlocal szWndCaption, 'Menu',0
	sc CreateWindowEx, 0, .szClassName, .szWndCaption, WS_OVERLAPPEDWINDOW | WS_VISIBLE, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, .hInstance, NULL
	mov	._hwnd, eax
	sc ShowWindow, ._hwnd, .nCmdShow
	sc UpdateWindow, ._hwnd
_WinMain_Loop:
	sc GetMessage, ._msg, NULL, 0, 0
	cmp	eax, TRUE
	jne	_WinMain_Loop_End
	sc TranslateMessage, ._msg
	sc DispatchMessage, ._msg
	jmp	_WinMain_Loop
_WinMain_Loop_End:
	mov	eax, [edi + MSG.wParam]
	jmp	_WinMain_End
_WinMain_Fail:
	TEXTlocal szErrorMsg, 'Failed to register window class!',0
	sc MessageBox, NULL, .szErrorMsg, .szWndCaption, MB_ICONERROR
_WinMain_End:
	WinMainEpilogue
endproc
;
;-----------------------------------------------------------------------
;
proc _WndProc, hwnd, message, wParam, lParam
	ddlocal		_hdc
	struclocal	_rect, RECT, _ps, PAINTSTRUCT
	TEXTlocal	_szOutputString, '                                       ',0
	endlocals
	CallbackPrologue
	switch .message
		case WM_PAINT
			sc BeginPaint, .hwnd, ._ps
			mov	._hdc, eax
			sc GetClientRect, .hwnd, ._rect
			;
			; For this demonstration, I've made the string displayed variable
			;
			sc DrawText, ._hdc, ._szOutputString, -1, ._rect, DT_SINGLELINE | DT_CENTER | DT_VCENTER
			sc EndPaint, .hwnd, ._ps
			xor	eax,eax
			break
		case WM_COMMAND
			;
			; Menu item chosen so the loword of wParam holds the
			; ID of the menu item selected, so we act according to
			; what it holds
			;
			mov	eax, .wParam
			and	eax, $0ffff		; mask off bits (hiword should be zero anyway)
			switch eax
				case IDM_FILE_NEW
					;
					; File|New, so change the string displayed in the middle of the window
					;
					TEXTlocal _szIDM_FILE_NEW, 'File|New',0
					sc wvsprintf, ._szOutputString, ._szIDM_FILE_NEW, ._szIDM_FILE_NEW
					break
				case IDM_FILE_EXIT
					;
					; The exit menu item is a special case - we want to force
					; application to quit, and do this by sending a WM_CLOSE message
					; via the SendMessage function, which takes four parameters:
					;
					;  1. Window handle
					;  2. Message to send
					;  3. wParam
					;  4. lParam
					;
					sc SendMessage, .hwnd, WM_CLOSE, 0, 0
					break
				case IDM_MISC_CHECKED
					;
					; To turn this into a checkmark toggle, we need to know
					; the current state of the menu item, and can do this by
					; calling GetMenuState which takes three parameters:
					;
					;   1. Menu handle
					;   2. Menu item resource identifier
					;   3. Flags, see the help for the details (you'll rarely need them)
					;
					; First, we obtain the menu handle by calling GetMenu, which takes
					; a single parameter - the window handle with the menu we want
					;
					sc GetMenu, .hwnd
					;
					; We need to save this value, so place it in esi for the moment (because
					; we remember that any API call will not preserve eax, ecx or edx)
					;
					mov	esi,eax
					;
					; After all this, we can obtain the state of the menu item:
					;
					sc GetMenuState, esi, IDM_MISC_CHECKED, 0
					;
					; Having obtained the state, we mask off all the bits except the one
					; we're interested in - the check state - but first we set ecx to
					; hold the check state we're going to set for the menu item, we assume
					; to check it
					;
					mov	ecx, MF_CHECKED
					and	eax, MF_CHECKED
					if eax, ne, 0
						;
						; Non-zero, so it's currently checked so now we uncheck it
						;
						mov	ecx, MF_UNCHECKED
					endif
					;
					; Finally we set the state of the menu item to be checked or
					; unchecked via the CheckMenuItem function, which takes three parameters:
					;
					;   1. Menu handle
					;   2. Resource identifier
					;   3. State
					;
					sc CheckMenuItem, esi, IDM_MISC_CHECKED, ecx
					;
					; And of course change the displayed text
					;
					TEXTlocal _szIDM_MISC_CHECKED, 'Misc|Checked',0
					sc wvsprintf, ._szOutputString, ._szIDM_MISC_CHECKED, ._szIDM_MISC_CHECKED
					break
				case IDM_HELP_HELP
					TEXTlocal _szIDM_HELP_HELP, 'Help|Help',0
					sc wvsprintf, ._szOutputString, ._szIDM_HELP_HELP, ._szIDM_HELP_HELP
					break
				case IDM_HELP_ABOUT
					TEXTlocal _szIDM_HELP_ABOUT, 'Help|About',0
					sc wvsprintf, ._szOutputString, ._szIDM_HELP_ABOUT, ._szIDM_HELP_ABOUT
					break
			switchend
			;
			; Invalidate the window and force a repaint
			;
			sc InvalidateRect, .hwnd, NULL, TRUE
			xor	eax, eax
			break
		case WM_DESTROY
			sc PostQuitMessage, 0
			xor	eax,eax
			break
		default
			sc DefWindowProc, .hwnd, .message, .wParam, .lParam
	switchend
	CallbackEpilogue
endproc

[section .bss]

[section .data]
